<?php

include 'includes/session.php';
error_reporting(E_ALL);
ini_set('display_errors', 1);

include('phpqrcode/qrlib.php');



// Function to upload, rotate (if needed), resize, and save image
function uploadAndResizeImage($fileInputName, $targetWidth, $targetHeight, $targetPath) {
    if ($_FILES[$fileInputName]["error"] === 0) {
        $tmpName = $_FILES[$fileInputName]["tmp_name"];
        $info = getimagesize($tmpName); // Get image information

        if ($info !== false) {
            // Check if the image needs rotation based on EXIF data
            $sourceImage = imagecreatefromstring(file_get_contents($tmpName));
            $exif = @exif_read_data($tmpName);

            if (!empty($exif['Orientation'])) {
                switch ($exif['Orientation']) {
                    case 3:
                        $sourceImage = imagerotate($sourceImage, 180, 0);
                        break;
                    case 6:
                        $sourceImage = imagerotate($sourceImage, -90, 0);
                        break;
                    case 8:
                        $sourceImage = imagerotate($sourceImage, 90, 0);
                        break;
                }
            }

            // Resize the image
            $resizedImage = imagescale($sourceImage, $targetWidth, $targetHeight);

            // Generate a unique file name
            $fileName = uniqid() . "." . pathinfo($_FILES[$fileInputName]["name"], PATHINFO_EXTENSION);

            // Save the resized image
            $filePath = $targetPath . $fileName;
            imagejpeg($resizedImage, $filePath);

            return $fileName; // Return the generated file name
        } else {
            return false; // Error: Unsupported image format
        }
    } else {
        return false; // Error uploading the image
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $firstname = $_POST['firstname'];
    $lastname = $_POST['lastname'];
    $address = $_POST['address'];
    $birthdate = $_POST['birthdate'];
    $contact = $_POST['contact'];
    $gender = $_POST['gender'];
    $position = $_POST['position'];
    $schedule = $_POST['schedule'];
    $face_descriptor = $_POST['face_descriptor'];
    $filename = $_FILES['photo']['name'];
    $photo = $_FILES['photo']['tmp_name'];

    if (empty($firstname) || empty($filename)) {
        die("Name and photo are required.");
    }

    $photoFileName = '';

    if (!empty($filename)) {
        // Move uploaded photo to directory and resize it
        $photoFileName = uploadAndResizeImage("photo", 400, 400, '../images/');
        if ($photoFileName === false) {
            echo "Error uploading or processing the photo.";
            exit;
        }
    }

    // Creating employee ID
    $letters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $numbers = '0123456789';
    $employee_id = substr(str_shuffle($letters), 0, 3) . substr(str_shuffle($numbers), 0, 9);

    // Generate QR code for employee ID
    $data = "$employee_id";
    $qr_filename = 'qrcodes/' . md5($data) . '.png';

    // Set QR code size to 500x500 pixels
    $qr_options = [
        'size' => 20 // Adjust this value as needed for the desired size
    ];
    QRcode::png($data, $qr_filename, QR_ECLEVEL_L, 20, 2, false, 0xFFFFFF, 0x000000, $qr_options);

    $mysqli = new mysqli('localhost', 'safegua6_adds', '@mashaAllah1', 'safegua6_fursa');
  
    if ($mysqli->connect_error) {
        die("Connection failed: " . $mysqli->connect_error);
    }

    // Insert data into the database
    $sql = "INSERT INTO employees (employee_id, firstname, lastname, address, birthdate, contact_info, gender, position_id, schedule_id, face_descriptor, photo, qr_code, created_on) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";
    $stmt = $mysqli->prepare($sql);
    if (!$stmt) {
        die("Prepare failed: " . $mysqli->error);
    }
    $stmt->bind_param('ssssssssssss', $employee_id, $firstname, $lastname, $address, $birthdate, $contact, $gender, $position, $schedule, $face_descriptor, $photoFileName, $qr_filename);

    if ($stmt->execute()) {
        echo "Registration successful!";
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
    $mysqli->close();
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Register</title>
    <style>
        /* Reset default styles */
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
        }

        .container {
            max-width: 100%; /* Adjusted to fit mobile screens */
            margin: 20px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            font-weight: bold;
        }

        .form-group input[type="text"],
        .form-group input[type="date"],
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 8px;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
            font-size: 16px;
        }

        .form-group textarea {
            height: 100px;
            resize: vertical;
        }

        .form-group select {
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            background-image: url('data:image/svg+xml;utf8,<svg fill="none" viewBox="0 0 24 24" stroke="currentColor" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>');
            background-repeat: no-repeat;
            background-position: right 8px center;
            background-size: 12px;
            padding-right: 30px;
        }

        .form-group input[type="file"] {
            display: block;
        }

        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            background-color: #007bff;
            color: #fff;
            transition: background-color 0.3s;
        }

        .btn:hover {
            background-color: #0056b3;
        }
    </style>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
    
    <div class="container">
    
    <form id="employeeForm" action="z.php" method="POST" enctype="multipart/form-data">
        <div class="form-group">
            <label for="firstname" class="col-sm-3 control-label">Firstname</label>
            <div class="col-sm-9">
                <input type="text" class="form-control" id="firstname" name="firstname" required>
            </div>
        </div>
        <div class="form-group">
            <label for="lastname" class="col-sm-3 control-label">Lastname</label>
            <div class="col-sm-9">
                <input type="text" class="form-control" id="lastname" name="lastname" required>
            </div>
        </div>
        <div class="form-group">
            <label for="address" class="col-sm-3 control-label">Address</label>
            <div class="col-sm-9">
                <textarea class="form-control" name="address" id="address"></textarea>
            </div>
        </div>
        <div class="form-group">
            <label for="datepicker_add" class="col-sm-3 control-label">Birthdate</label>
            <div class="col-sm-9">
                <input type="date" class="form-control"  name="birthdate">
            </div>
        </div>
        <div class="form-group">
            <label for="contact" class="col-sm-3 control-label">Contact Info</label>
            <div class="col-sm-9">
                <input type="text" class="form-control" id="contact" name="contact">
            </div>
        </div>
        <div class="form-group">
            <label for="gender" class="col-sm-3 control-label">Gender</label>
            <div class="col-sm-9">
                <select class="form-control" name="gender" id="gender" required>
                    <option value="" selected>- Select -</option>
                    <option value="Male">Male</option>
                    <option value="Female">Female</option>
                </select>
            </div>
        </div>
        <div class="form-group">
            <label for="position" class="col-sm-3 control-label">Position</label>
            <div class="col-sm-9">
                <select class="form-control" name="position" id="position" required>
                    <option value="" selected>- Select -</option>
                    <?php
                        $sql = "SELECT * FROM position";
                        $query = $conn->query($sql);
                        while($prow = $query->fetch_assoc()){
                            echo "<option value='".$prow['id']."'>".$prow['description']."</option>";
                        }
                    ?>
                </select>
            </div>
        </div>
        <div class="form-group">
            <label for="schedule" class="col-sm-3 control-label">Schedule</label>
            <div class="col-sm-9">
                <select class="form-control" id="schedule" name="schedule" required>
                    <option value="" selected>- Select -</option>
                    <?php
                        $sql = "SELECT * FROM schedules";
                        $query = $conn->query($sql);
                        while($srow = $query->fetch_assoc()){
                            echo "<option value='".$srow['id']."'>".$srow['time_in'].' - '.$srow['time_out']."</option>";
                        }
                    ?>
                </select>
            </div>
        </div>
        <div class="form-group">
            <label for="photo" class="col-sm-3 control-label">Photo</label>
            <div class="col-sm-9">
              <input type="file" name="photo" id="photo" accept="image/*" required capture="camera">

            </div>
        </div>
        <div class="form-group">
            <label for="face_capture" class="col-sm-3 control-label">Face Capture</label>
            <div class="col-sm-9">
                <video id="video" width="100%" height="400" autoplay muted></video>
                <button type="button" id="captureButton" class="btn btn-primary">Capture Face</button>
                <input type="hidden" id="face_descriptor" name="face_descriptor" required>
            </div>
        </div>
        <input type="hidden" id="captureStatus" name="captureStatus" value="0">
        <button type="submit" class="btn btn-primary btn-flat"><i class="fa fa-save"></i> Save</button>
    </form>
</div>
    <script defer src="../../fursa/face-api.js-master/weights/a.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', async () => {
            try {
                console.log('Loading models...');
                await faceapi.nets.ssdMobilenetv1.loadFromUri('../../fursa/face-api.js-master/weights');
                await faceapi.nets.faceRecognitionNet.loadFromUri('../../fursa/face-api.js-master/weights');
                await faceapi.nets.faceLandmark68Net.loadFromUri('../../fursa/face-api.js-master/weights');
                console.log('Models loaded.');
                setupCamera();
            } catch (err) {
                console.error('Error loading models: ', err);
            }

            document.getElementById('captureButton').addEventListener('click', captureImage);
        });

        async function setupCamera() {
            const video = document.getElementById('video');
            navigator.mediaDevices.getUserMedia({ video: {} })
                .then(stream => {
                    video.srcObject = stream;
                })
                .catch(err => console.error('Error accessing camera: ', err));
        }

        async function captureImage() {
            const video = document.getElementById('video');
            const canvas = document.createElement('canvas');
            const context = canvas.getContext('2d');

            canvas.width = video.videoWidth;
            canvas.height = video.videoHeight;
            context.drawImage(video, 0, 0, canvas.width, canvas.height);

            const detection = await faceapi.detectSingleFace(video).withFaceLandmarks().withFaceDescriptor();
            if (detection) {
                document.getElementById('face_descriptor').value = JSON.stringify(detection.descriptor);
                document.getElementById('captureStatus').value = "1";
                alert('Face captured successfully.');
            } else {
                alert('No face detected. Please try again.');
            }
        }
    </script>
    

</body>
</html>
