<?php
include 'conn.php';
include 'timezone.php';

$data = json_decode(file_get_contents('php://input'), true);
$employee = $data['employee'];
$input_face_descriptor = json_decode($data['captured_image'], true);

$output = array('error' => false);

$sql = "SELECT * FROM employees WHERE employee_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $employee);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$stmt->close();

if ($row) {
    $db_face_descriptor = json_decode($row['face_descriptor'], true);

    // Calculate the Euclidean distance between the descriptors
    $distance = 0.0;
    for ($i = 0; $i < count($db_face_descriptor); $i++) {
        $distance += pow($input_face_descriptor[$i] - $db_face_descriptor[$i], 2);
    }
    $distance = sqrt($distance);

    if ($distance < 0.4) { // 0.4 is a stricter threshold for ~60% match
        $employee_id = $row['id'];
        $date_now = date('Y-m-d');

        // Check if already timed in today
        $sql = "SELECT * FROM attendance WHERE employee_id = ? AND date = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("is", $employee_id, $date_now);
        $stmt->execute();
        $result = $stmt->get_result();
        $attendance_row = $result->fetch_assoc();
        $stmt->close();

        if ($attendance_row) {
            if ($attendance_row['time_out'] == '00:00:00') {
                // Log time out
                $sql = "UPDATE attendance SET time_out = NOW() WHERE id = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("i", $attendance_row['id']);
                if ($stmt->execute()) {
                    $output['message'] = 'Time out: ' . $row['firstname'] . ' ' . $row['lastname'];
                } else {
                    $output['error'] = true;
                    $output['message'] = $stmt->error;
                }
                $stmt->close();
            } else {
                $output['error'] = true;
                $output['message'] = 'You have already timed out for today';
            }
        } else {
            // Log time in
            $sched = $row['schedule_id'];
            $lognow = date('H:i:s');
            $sql = "SELECT * FROM schedules WHERE id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i", $sched);
            $stmt->execute();
            $result = $stmt->get_result();
            $srow = $result->fetch_assoc();
            $stmt->close();

            $logstatus = ($lognow > $srow['time_in']) ? 0 : 1;

            $sql = "INSERT INTO attendance (employee_id, date, time_in, status) VALUES (?, ?, NOW(), ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("isi", $employee_id, $date_now, $logstatus);
            if ($stmt->execute()) {
                $output['message'] = 'Time in: ' . $row['firstname'] . ' ' . $row['lastname'];
            } else {
                $output['error'] = true;
                $output['message'] = $stmt->error;
            }
            $stmt->close();
        }
    } else {
        $output['error'] = true;
        $output['message'] = 'Face not recognized. Please try again.';
    }
} else {
    $output['error'] = true;
    $output['message'] = 'Employee ID not found';
}

echo json_encode($output);
?>
