<?php 
error_reporting(E_ALL);
ini_set('display_errors', 1);

$servername = "localhost";
$username = "safegua6_adds";
$password = "@mashaAllah1";
$dbname = "safegua6_fursa";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $input_face_descriptor = json_decode($_POST['captured_image'], true);

    // Fetch all users and their face descriptors from the database
    $sql = "SELECT username, face_descriptor FROM users";
    $result = $conn->query($sql);

    $login_successful = false;

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $db_face_descriptor = json_decode($row['face_descriptor'], true);

            // Calculate the Euclidean distance between the descriptors
            $distance = 0.0;
            for ($i = 0; $i < count($db_face_descriptor); $i++) {
                $distance += pow($input_face_descriptor[$i] - $db_face_descriptor[$i], 2);
            }
            $distance = sqrt($distance);

            // Check if the face match is above 40% (adjust the threshold accordingly)
            if ($distance < 0.6) { // 0.6 is a threshold for ~40% match
                $login_successful = true;
                break;
            }
        }
    }

    if ($login_successful) {
        echo "Login successful";
    } else {
        echo "Invalid face. Please try again.";
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login</title>
    <script defer src="face-api.js-master/weights/a.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', async () => {
            try {
                console.log('Loading models...');
                await faceapi.nets.ssdMobilenetv1.loadFromUri('/t/face-api.js-master/weights');
                await faceapi.nets.faceRecognitionNet.loadFromUri('/t/face-api.js-master/weights');
                await faceapi.nets.faceLandmark68Net.loadFromUri('/t/face-api.js-master/weights');
                console.log('Models loaded.');
                setupCamera();
            } catch (err) {
                console.error('Error loading models: ', err);
            }

            // Automatically capture the image every few seconds
            setInterval(captureImage, 3000);
        });

        async function setupCamera() {
            const video = document.getElementById('video');
            navigator.mediaDevices.getUserMedia({ video: {} })
                .then(stream => {
                    video.srcObject = stream;
                })
                .catch(err => console.error('Error accessing camera: ', err));
        }

        async function captureImage() {
            const video = document.getElementById('video');
            const canvas = document.createElement('canvas');
            const context = canvas.getContext('2d');

            canvas.width = video.videoWidth;
            canvas.height = video.videoHeight;
            context.drawImage(video, 0, 0, canvas.width, canvas.height);

            const detection = await faceapi.detectSingleFace(video).withFaceLandmarks().withFaceDescriptor();
            if (detection) {
                document.getElementById('captured_image').value = JSON.stringify(detection.descriptor);
                document.getElementById('loginForm').submit();
            }
        }
    </script>
</head>
<body>
    <h2>Login</h2>
    <video id="video" width="720" height="560" autoplay muted></video>
    <form id="loginForm" action="login.php" method="post">
        <input type="hidden" id="captured_image" name="captured_image">
    </form>
</body>
</html>
